package some;

public class SQLCreator {
	public String create(TableInfo tableInfo) {
		StringBuffer sql = new StringBuffer();

		sql.append("CREATE TABLE " + tableInfo.getTableName() + " (\n");

		for (String key : tableInfo.getColumnMap().keySet()) {
			ColumnInfo column = tableInfo.getColumnMap().get(key);

			sql.append("    ");
			sql.append(String.format("%-30s %s",
						column.getColumnName(),
						column.getColumnAttr()));
			if (!column.getColumnAttr().equalsIgnoreCase("date")) {
				if (column.getFloatingPos() > 0) {
					sql.append(String.format("(%d.%d)",
							column.getColumnLength(),
							column.getFloatingPos()));
				} else {
					sql.append(String.format("(%d)",
							column.getColumnLength()));
				}
			}
			if (!column.getNullable().equalsIgnoreCase("N")) {
				sql.append(" NOT NULL");
			}
			sql.append(",\n");
		}

		int i = 0;
		for(String key : tableInfo.getPrimaryKeyMap().keySet()) {
			ColumnInfo column = tableInfo.getPrimaryKeyMap().get(key);
			if (i == 0) {
				sql.append("CONSTRAINT " + tableInfo.getTableName() + "_IDX01 PRIMARY KEY (\n");
				sql.append("    ");
			} else {
				sql.append("    ,");
			}
			sql.append(column.getColumnName() + "\n");
			i++;
		}
		sql.append("    )\n)\n");

		return sql.toString();
	}
}
